/***************************************************************************
                          splamodel.hpp  -  description
                             -------------------
    begin                : Don  27 2007
    copyright            : (C) 2007 by Krippel Harald
    email                : harald@the-develop.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPLAMODEL_HPP
#define SPLAMODEL_HPP

/**
	@author Harald Krippel, Bernhard Arnberger
*/

#include <main.h>

class splaModel
{
public:
    splaModel( const int id ,FolderListItem *item);
    ~splaModel();
    int getHandle () const;
    static int getParentID (const int id, FolderListItem *item);
    void update ( double dt );
    void playSound ();
    void stopSound ();
    void setPosition ( float x, float y, float z, float h, float p, float r );
    float getPositionX () const;
    float getPositionY () const;
    float getPositionZ () const;
    float getPositionH () const;
    float getPositionP () const;
    float getPositionR () const;
    int switchScene();
    int switchCamera();
    void setAttribute(char *attr, char *value);
    QString getAttribute(char *attr);
    FolderListItem * getFolderListItem();
    void addRelTorque ( float velx, float vely, float velz );
    void setSequence ( int sequenz , int mode );
    void setAngularVel ( float velx, float vely, float velz );
    void addRelForce ( float velx, float vely, float velz );
    void setLinVel ( float velx, float vely, float velz );
    void setRotation ( float h, float p, float r );
    void Rotation ( float h, float p, float r );


    static QList<splaModel *> g_Models;

protected:

  int            play;
  int            updateme;
  int            handle ;
  FolderListItem *miditem;  // modell pointer id == id from tree
  sgCoord        pos ;


};

#endif
