/***************************************************************************
                         qgsalgorithmexecutespatialitequeryregistered.h
                         ------------------------------
    begin                : May 2020
    copyright            : (C) 2020 by Alexander Bruy
    email                : alexander dot bruy at gmail dot com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QGSALGORITHMEXECUTESPATIALITEQUERYREGISTERED_H
#define QGSALGORITHMEXECUTESPATIALITEQUERYREGISTERED_H

#define SIP_NO_FILE

#include "qgis_sip.h"
#include "qgsprocessingalgorithm.h"

///@cond PRIVATE

/**
 * Native execute SpoatiaLite (registered) query algorithm.
 */
class QgsExecuteRegisteredSpatialiteQueryAlgorithm : public QgsProcessingAlgorithm
{

  public:

    QgsExecuteRegisteredSpatialiteQueryAlgorithm() = default;
    void initAlgorithm( const QVariantMap &configuration = QVariantMap() ) override;
    QString name() const override;
    QString displayName() const override;
    QStringList tags() const override;
    QString group() const override;
    QString groupId() const override;
    QString shortHelpString() const override;
    QgsExecuteRegisteredSpatialiteQueryAlgorithm *createInstance() const override SIP_FACTORY;

  protected:

    QVariantMap processAlgorithm( const QVariantMap &parameters,
                                  QgsProcessingContext &context, QgsProcessingFeedback *feedback ) override;
};

///@endcond PRIVATE

#endif // QGSALGORITHMEXECUTESPATIALITEQUERYREGISTERED_H
