/***************************************************************************
 *   Copyright (C) 2009 by Johan Maes -ON4QZ                               *
 *   on4qz@telenet.be   http://users.telenet.be/on4qz                      *
 *   http://users.telenet.be/on4qz                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef RIGCONTROL_H
#define RIGCONTROL_H
#include <QObject>
#include <QComboBox>
#include <hamlib/rig.h>

bool model_Sort(const rig_caps *caps1,const rig_caps *caps2);


class rigControl: public QObject
{
	Q_OBJECT
public:
	rigControl();
	~rigControl();
	bool init();
	bool enabled() {return rigControlEnabled;}
	bool getFrequency(double &frequency);
	bool setFrequency(double frequency);
	bool getMode(QString &mode);
  bool setMode(QString mode);
  bool setPTT(bool On);
  int getModelNumber(int idx);
  int getRadioModelIndex();
  bool getRadioList(QComboBox *cb);
  void disable();


private:
 	hamlib_port_t myport;
	RIG *my_rig;            //handle to rig (nstance) 
	freq_t freq;            // frequency  
	rmode_t rmode;          // radio mode of operation 
	pbwidth_t width;
	vfo_t vfo;              // vfo selection 
	int strength;           // S-Meter level 
	int retcode;            // generic return code from functions 
	rig_model_t myrig_model;
	bool rigControlEnabled;
  void errorMessage(int errorCode,QString command);
  void getRadioList();
};

extern rigControl *rigController;

#endif
