/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.perflib;

import com.squareup.haha.guava.collect.ImmutableList;
import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.Field;
import com.squareup.haha.perflib.Heap;
import com.squareup.haha.perflib.NonRecursiveVisitor;
import com.squareup.haha.perflib.StackTrace;
import com.squareup.haha.perflib.Type;
import com.squareup.haha.perflib.Visitor;
import com.squareup.haha.perflib.io.HprofBuffer;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Instance {
    protected final long mId;
    protected final StackTrace mStack;
    long mClassId;
    Heap mHeap;
    int mSize;
    int mTopologicalOrder;
    int mDistanceToGcRoot = Integer.MAX_VALUE;
    boolean mReferencesAdded = false;
    Instance mNextInstanceToGcRoot = null;
    private Instance mImmediateDominator;
    private long[] mRetainedSizes;
    private final ArrayList<Instance> mHardReferences = new ArrayList();
    private ArrayList<Instance> mSoftReferences = null;

    Instance(long id, StackTrace stackTrace) {
        this.mId = id;
        this.mStack = stackTrace;
    }

    public long getId() {
        return this.mId;
    }

    public long getUniqueId() {
        return this.getId() & this.mHeap.mSnapshot.getIdSizeMask();
    }

    public abstract void accept(Visitor var1);

    public void setClassId(long classId) {
        this.mClassId = classId;
    }

    public ClassObj getClassObj() {
        return this.mHeap.mSnapshot.findClass(this.mClassId);
    }

    public final int getCompositeSize() {
        CompositeSizeVisitor visitor = new CompositeSizeVisitor();
        visitor.doVisit(ImmutableList.of(this));
        return visitor.getCompositeSize();
    }

    public int getSize() {
        return this.mSize;
    }

    public void setSize(int size) {
        this.mSize = size;
    }

    public void setHeap(Heap heap) {
        this.mHeap = heap;
    }

    public Heap getHeap() {
        return this.mHeap;
    }

    public int getTopologicalOrder() {
        return this.mTopologicalOrder;
    }

    public void setTopologicalOrder(int topologicalOrder) {
        this.mTopologicalOrder = topologicalOrder;
    }

    public Instance getImmediateDominator() {
        return this.mImmediateDominator;
    }

    public void setImmediateDominator(Instance dominator) {
        this.mImmediateDominator = dominator;
    }

    public int getDistanceToGcRoot() {
        return this.mDistanceToGcRoot;
    }

    public Instance getNextInstanceToGcRoot() {
        return this.mNextInstanceToGcRoot;
    }

    public void setDistanceToGcRoot(int newDistance) {
        assert (newDistance < this.mDistanceToGcRoot);
        this.mDistanceToGcRoot = newDistance;
    }

    public void setNextInstanceToGcRoot(Instance instance) {
        this.mNextInstanceToGcRoot = instance;
    }

    public void resetRetainedSize() {
        ArrayList<Heap> allHeaps = this.mHeap.mSnapshot.mHeaps;
        if (this.mRetainedSizes == null) {
            this.mRetainedSizes = new long[allHeaps.size()];
        } else {
            Arrays.fill(this.mRetainedSizes, 0L);
        }
        this.mRetainedSizes[allHeaps.indexOf((Object)this.mHeap)] = this.getSize();
    }

    public void addRetainedSize(int heapIndex, long size) {
        int n = heapIndex;
        this.mRetainedSizes[n] = this.mRetainedSizes[n] + size;
    }

    public long getRetainedSize(int heapIndex) {
        return this.mRetainedSizes[heapIndex];
    }

    public long getTotalRetainedSize() {
        if (this.mRetainedSizes == null) {
            return 0L;
        }
        long totalSize = 0L;
        long[] arr$ = this.mRetainedSizes;
        int len$ = this.mRetainedSizes.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            long mRetainedSize = arr$[i$];
            totalSize += mRetainedSize;
        }
        return totalSize;
    }

    public void addReference(Field field, Instance reference) {
        if (reference.getIsSoftReference() && field != null && field.getName().equals("referent")) {
            if (this.mSoftReferences == null) {
                this.mSoftReferences = new ArrayList();
            }
            this.mSoftReferences.add(reference);
            return;
        }
        this.mHardReferences.add(reference);
    }

    public ArrayList<Instance> getHardReferences() {
        return this.mHardReferences;
    }

    public ArrayList<Instance> getSoftReferences() {
        return this.mSoftReferences;
    }

    public boolean getIsSoftReference() {
        return false;
    }

    protected Object readValue(Type type) {
        switch (type) {
            case OBJECT: {
                long id = this.readId();
                return this.mHeap.mSnapshot.findInstance(id);
            }
            case BOOLEAN: {
                return this.getBuffer().readByte() != 0;
            }
            case CHAR: {
                return Character.valueOf(this.getBuffer().readChar());
            }
            case FLOAT: {
                return Float.valueOf(this.getBuffer().readFloat());
            }
            case DOUBLE: {
                return this.getBuffer().readDouble();
            }
            case BYTE: {
                return this.getBuffer().readByte();
            }
            case SHORT: {
                return this.getBuffer().readShort();
            }
            case INT: {
                return this.getBuffer().readInt();
            }
            case LONG: {
                return this.getBuffer().readLong();
            }
        }
        return null;
    }

    protected long readId() {
        switch (this.mHeap.mSnapshot.getTypeSize(Type.OBJECT)) {
            case 1: {
                return this.getBuffer().readByte();
            }
            case 2: {
                return this.getBuffer().readShort();
            }
            case 4: {
                return this.getBuffer().readInt();
            }
            case 8: {
                return this.getBuffer().readLong();
            }
        }
        return 0L;
    }

    protected int readUnsignedByte() {
        byte by = this.getBuffer().readByte();
        return by & 0xFF;
    }

    protected int readUnsignedShort() {
        return this.getBuffer().readShort() & 0xFFFF;
    }

    protected HprofBuffer getBuffer() {
        return this.mHeap.mSnapshot.mBuffer;
    }

    public static class CompositeSizeVisitor
    extends NonRecursiveVisitor {
        int mSize = 0;

        @Override
        protected void defaultAction(Instance node) {
            this.mSize += node.getSize();
        }

        public int getCompositeSize() {
            return this.mSize;
        }
    }
}

