# vim: ft=python fileencoding=utf-8 sts=4 sw=4 et:

# Copyright 2016-2021 Florian Bruhin (The-Compiler) <mail@qutebrowser.org>
#
# This file is part of qutebrowser.
#
# qutebrowser is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# qutebrowser is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with qutebrowser.  If not, see <https://www.gnu.org/licenses/>.

"""Test qutebrowser.misc.earlyinit."""

import sys

import pytest

from qutebrowser.misc import earlyinit


@pytest.mark.parametrize('attr', ['stderr', '__stderr__'])
def test_init_faulthandler_stderr_none(monkeypatch, attr):
    """Make sure init_faulthandler works when sys.stderr/__stderr__ is None."""
    monkeypatch.setattr(sys, attr, None)
    earlyinit.init_faulthandler()


@pytest.mark.parametrize('same', [True, False])
def test_qt_version(same):
    if same:
        qt_version_str = '5.14.0'
        expected = '5.14.0'
    else:
        qt_version_str = '5.13.0'
        expected = '5.14.0 (compiled 5.13.0)'
    actual = earlyinit.qt_version(qversion='5.14.0', qt_version_str=qt_version_str)
    assert actual == expected


def test_qt_version_no_args():
    """Make sure qt_version without arguments at least works."""
    earlyinit.qt_version()
