% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clearExternalDir.R
\name{clearExternalDir}
\alias{clearExternalDir}
\alias{clearObsoleteDir}
\title{Clear the external installation directory}
\usage{
clearExternalDir(
  path = getExternalDir(),
  package = NULL,
  obsolete.only = FALSE
)
}
\arguments{
\item{path}{String containing a path to the external directory containing the current conda installation and environments.}

\item{package}{String containing the name of a client R package.
If provided, all environments will be removed for this package.}

\item{obsolete.only}{Logical scalar indicating whether to only remove environments for obsolete package versions.}
}
\value{
If \code{package=NULL} and \code{obsolete.only=FALSE}, all of the conda instances (and associated environments) in the external directory are destroyed.
If \code{obsolete.only=TRUE}, the conda instances and environments associated with \pkg{basilisk} versions older than the current version are destroyed.

If \code{package} is supplied and \code{obsolete.only=FALSE}, all conda environments for the specified client package are destroyed.
If \code{obsolete.only=FALSE}, only the environments for older versions of the client package are destroyed.
}
\description{
Clear the external installation directory by removing all or obsolete conda instances/environments.
This can be used to free up some space if the expiry mechanism is not fast enough at deleting unused environments.
}
\examples{
# We can't actually run clearExternalDir() here, as it 
# relies on basilisk already being installed.
print("dummy test to pass BiocCheck")

}
\seealso{
\code{\link{getExternalDir}}, which determines the location of the external directory.

\code{\link{installConda}}, for the motivation behind this function.
}
\author{
Aaron Lun
}
