### - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
### The Standard Genetic Code

### From the "coding DNA strand" (aka "sense DNA strand" or "non-template DNA
### strand").
GENETIC_CODE <- c(
    TTT="F",
    TTC="F",
    TTA="L",
    TTG="L",

    TCT="S",
    TCC="S",
    TCA="S",
    TCG="S",

    TAT="Y",
    TAC="Y",
    TAA="*",
    TAG="*",

    TGT="C",
    TGC="C",
    TGA="*",
    TGG="W",

    CTT="L",
    CTC="L",
    CTA="L",
    CTG="L",

    CCT="P",
    CCC="P",
    CCA="P",
    CCG="P",

    CAT="H",
    CAC="H",
    CAA="Q",
    CAG="Q",

    CGT="R",
    CGC="R",
    CGA="R",
    CGG="R",

    ATT="I",
    ATC="I",
    ATA="I",
    ATG="M",

    ACT="T",
    ACC="T",
    ACA="T",
    ACG="T",

    AAT="N",
    AAC="N",
    AAA="K",
    AAG="K",

    AGT="S",
    AGC="S",
    AGA="R",
    AGG="R",

    GTT="V",
    GTC="V",
    GTA="V",
    GTG="V",

    GCT="A",
    GCC="A",
    GCA="A",
    GCG="A",

    GAT="D",
    GAC="D",
    GAA="E",
    GAG="E",

    GGT="G",
    GGC="G",
    GGA="G",
    GGG="G"
)

### From the "RNA transcript".
RNA_GENETIC_CODE <- GENETIC_CODE
names(RNA_GENETIC_CODE) <- chartr("T", "U", names(GENETIC_CODE))

