% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_dmSQTLprecision.R
\docType{class}
\name{dmSQTLprecision-class}
\alias{dmSQTLprecision-class}
\alias{mean_expression,dmSQTLprecision-method}
\alias{common_precision,dmSQTLprecision-method}
\alias{genewise_precision,dmSQTLprecision-method}
\title{dmSQTLprecision object}
\usage{
\S4method{mean_expression}{dmSQTLprecision}(x)

\S4method{common_precision}{dmSQTLprecision}(x)

\S4method{genewise_precision}{dmSQTLprecision}(x)
}
\arguments{
\item{x}{dmSQTLprecision object.}
}
\value{
\itemize{ \item \code{mean_expression(x)}: Get a data frame with mean gene 
expression. \item \code{common_precision(x)}: Get common precision. \item 
\code{genewise_precision(x)}: Get a data frame with gene-wise precision.}
}
\description{
dmSQTLprecision extends the \code{\linkS4class{dmSQTLdata}} by adding the 
precision estimates of Dirichlet-multinomial distribution used to model the 
feature (e.g., transcript, exon, exonic bin) counts for each gene-SNP pair in
the QTL analysis. Result of \code{\link{dmPrecision}}.
}
\section{Slots}{

\describe{
\item{\code{mean_expression}}{Numeric vector of mean gene expression.}

\item{\code{common_precision}}{Numeric value of estimated common precision.}

\item{\code{genewise_precision}}{List of estimated gene-wise precisions. Each element
of this list is a vector of precisions estimated for all the genotype
blocks assigned to a given gene.}
}}

\examples{
# --------------------------------------------------------------------------
# Create dmSQTLdata object
# --------------------------------------------------------------------------
# Use subsets of data defined in the GeuvadisTranscriptExpr package

library(GeuvadisTranscriptExpr)
\donttest{
geuv_counts <- GeuvadisTranscriptExpr::counts
geuv_genotypes <- GeuvadisTranscriptExpr::genotypes
geuv_gene_ranges <- GeuvadisTranscriptExpr::gene_ranges
geuv_snp_ranges <- GeuvadisTranscriptExpr::snp_ranges

colnames(geuv_counts)[c(1,2)] <- c("feature_id", "gene_id")
colnames(geuv_genotypes)[4] <- "snp_id"
geuv_samples <- data.frame(sample_id = colnames(geuv_counts)[-c(1,2)])

d <- dmSQTLdata(counts = geuv_counts, gene_ranges = geuv_gene_ranges,  
  genotypes = geuv_genotypes, snp_ranges = geuv_snp_ranges, 
  samples = geuv_samples, window = 5e3)

# --------------------------------------------------------------------------
# sQTL analysis - simple group comparison
# --------------------------------------------------------------------------

## Filtering
d <- dmFilter(d, min_samps_gene_expr = 70, min_samps_feature_expr = 5,
  minor_allele_freq = 5, min_gene_expr = 10, min_feature_expr = 10)
  
plotData(d)

## To make the analysis reproducible
set.seed(123)
## Calculate precision
d <- dmPrecision(d)

plotPrecision(d)
}
}
\seealso{
\code{\linkS4class{dmSQTLdata}}, \code{\linkS4class{dmSQTLfit}}, 
  \code{\linkS4class{dmSQTLtest}}
}
\author{
Malgorzata Nowicka
}
