% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiAssayExperimentToMAF.R
\name{MultiAssayExperimentToMAF}
\alias{MultiAssayExperimentToMAF}
\title{Convert MultiAssayExperiment to MAF class}
\usage{
MultiAssayExperimentToMAF(x, synAssay = "maf_syn", nonSynAssay = "maf_nonSyn")
}
\arguments{
\item{x}{A \code{MultiAssayExperiment} object}

\item{synAssay}{\code{character(1)} The name of the \code{ExperimentList} element in
the \code{MultiAssayExperiment} that identifies synonymous variant
classifications (default \code{"maf_syn"}).}

\item{nonSynAssay}{\code{character(1)} The name of the \code{ExperimentList} element in
the \code{MultiAssayExperiment} that identifies non-synonymous variant
classifications (default \code{"maf_nonSyn"}).}
}
\value{
A \code{MAF} class object
}
\description{
Take a \code{MultiAssayExperiment} object with specific mutation
assays and convert these into a \code{maftools} representation. The names
provided via \code{synAssay} and \code{nonSynAssay} must match exactly those
assays in the \code{MultiAssayExperiment}.
}
\seealso{
\code{?maftools::MAF}
}
