% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listToMap.R, R/mapToList.R
\name{listToMap}
\alias{listToMap}
\alias{mapToList}
\title{Convert map from data.frame or DataFrame to list and vice versa}
\usage{
listToMap(listmap, fill = TRUE)

mapToList(dfmap, assayCol = "assay")
}
\arguments{
\item{listmap}{A named \code{list} object containing \code{DataFrame}s
with "primary" and "colname" columns}

\item{fill}{\code{logical(1)} Whether to fill the map with an empty \code{DataFrame}
when empty elements are present in the input list}

\item{dfmap}{A \code{data.frame} or \code{DataFrame} object with
identifiers in the first column}

\item{assayCol}{A character vector of length one indicating the assay
names column}
}
\value{
A \code{\link{DataFrame}} class object of names

A \code{list} object of DataFrames for each assay
}
\description{
The \code{mapToList} function provides a convenient way of reordering a
\code{data.frame} to a \code{list}. The \code{listToMap} function does the
opposite by taking a \code{list} and converting it to \code{DataFrame}.
}
\section{Functions}{
\itemize{
\item \code{listToMap()}: The inverse of the listToMap operation

}}
\examples{
example("MultiAssayExperiment")

## Create a sampleMap from a list using the listToMap function
sampMap <- listToMap(maplist)

## The inverse operation is also available
maplist <- mapToList(sampMap)
}
