% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callAmplificationsInLowPurity.R
\name{callAmplificationsInLowPurity}
\alias{callAmplificationsInLowPurity}
\title{Calling of amplifications in low purity samples}
\usage{
callAmplificationsInLowPurity(
  res,
  normalDB,
  pvalue.cutoff = 0.001,
  percentile.cutoff = 90,
  min.width = 3,
  all.genes = FALSE,
  purity = NULL,
  BPPARAM = NULL
)
}
\arguments{
\item{res}{Return object of the \code{\link{runAbsoluteCN}} function.}

\item{normalDB}{Normal database, created with
\code{\link{createNormalDatabase}}.}

\item{pvalue.cutoff}{Copy numbers log-ratio cutoffs to call
amplifications as calculating using the log-ratios observed in
\code{normalDB}}

\item{percentile.cutoff}{Only report genes with log2-ratio mean
exceeding this sample-wise cutoff.}

\item{min.width}{Minimum number of targets}

\item{all.genes}{If \code{FALSE}, then only return amplifications
passing the thresholds.}

\item{purity}{If not \code{NULL}, then scale log2-ratios to the
corresponding integer copy number. Useful when accurate ctDNA
fractions (between 4-10 percent) are available.}

\item{BPPARAM}{\code{BiocParallelParam} object. If \code{NULL}, does not
use parallelization for fitting local optima.}
}
\value{
A \code{data.frame} with gene-level amplification calls.
}
\description{
Function to extract amplification from a
\code{\link{runAbsoluteCN}} return object in samples of too low purity
for the standard \code{\link{callAlterations}}.
}
\examples{

data(purecn.example.output)
normal.coverage.file <- system.file("extdata", "example_normal.txt", 
    package="PureCN")
normal2.coverage.file <- system.file("extdata", "example_normal2.txt", 
    package="PureCN")
normal.coverage.files <- c(normal.coverage.file, normal2.coverage.file)
normalDB <- createNormalDatabase(normal.coverage.files)
callAmplificationsInLowPurity(purecn.example.output, normalDB)["EIF2A", ]

}
\seealso{
\code{\link{runAbsoluteCN}} \code{\link{callAlterations}}
}
\author{
Markus Riester
}
