% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poolCoverage.R
\name{poolCoverage}
\alias{poolCoverage}
\title{Pool coverage from multiple samples}
\usage{
poolCoverage(all.data, remove.chrs = c(), w = NULL)
}
\arguments{
\item{all.data}{List of normals, read with \code{\link{readCoverageFile}}.}

\item{remove.chrs}{Remove these chromosomes from the pool.}

\item{w}{\code{numeric(length(all.data))} vector of weights. If \code{NULL},
weight all samples equally.}
}
\value{
A \code{data.frame} with the averaged coverage over all normals.
}
\description{
Averages the coverage of a list of samples.
}
\examples{

normal.coverage.file <- system.file("extdata", "example_normal.txt",
    package = "PureCN")
normal2.coverage.file <- system.file("extdata", "example_normal2.txt",
    package = "PureCN")
normal.coverage.files <- c(normal.coverage.file, normal2.coverage.file)
pool <- poolCoverage(lapply(normal.coverage.files, readCoverageFile),
     remove.chrs = c("chrX", "chrY"))

}
\seealso{
\code{\link{readCoverageFile}}
}
\author{
Markus Riester
}
