% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callAlterations.R
\name{callAlterations}
\alias{callAlterations}
\title{Calling of amplifications and deletions}
\usage{
callAlterations(
  res,
  id = 1,
  cutoffs = c(0.5, 6, 7),
  log.ratio.cutoffs = c(-0.9, 0.9),
  failed = NULL,
  all.genes = FALSE
)
}
\arguments{
\item{res}{Return object of the \code{\link{runAbsoluteCN}} function.}

\item{id}{Candidate solutions to be used. \code{id=1} will use the maximum
likelihood (or curated) solution.}

\item{cutoffs}{Copy numbers cutoffs to call losses, focal amplifications and
broad amplifications.}

\item{log.ratio.cutoffs}{Copy numbers log-ratio cutoffs to call losses and
amplifications in failed samples.}

\item{failed}{Indicates whether sample was failed. If \code{NULL}, use
available annotation, which can be set in the curation file.}

\item{all.genes}{If \code{FALSE}, then only return amplifications and
deletions passing the thresholds.}
}
\value{
A \code{data.frame} with gene-level amplification and deletion
calls.
}
\description{
Function to extract major copy number alterations from a
\code{\link{runAbsoluteCN}} return object.
}
\examples{

data(purecn.example.output)
callAlterations(purecn.example.output)
callAlterations(purecn.example.output, all.genes=TRUE)["ESR2",]

}
\seealso{
\code{\link{runAbsoluteCN}}
}
\author{
Markus Riester
}
