% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5create.R
\name{h5_createGroup}
\alias{h5_createGroup}
\alias{h5createGroup}
\title{Create HDF5 group}
\usage{
h5createGroup(file, group)
}
\arguments{
\item{file}{The filename (character) of the file in which the dataset will
be located. For advanced programmers it is possible to provide an object of
class \linkS4class{H5IdComponent} representing a H5 location identifier
(file or group). See \code{\link[=H5Fcreate]{H5Fcreate()}}, \code{\link[=H5Fopen]{H5Fopen()}},
\code{\link[=H5Gcreate]{H5Gcreate()}}, \code{\link[=H5Gopen]{H5Gopen()}} to create an object of this
kind.}

\item{group}{The name of the new group. The name can contain a hierarchy of
groupnames, e.g. \code{"/group1/group2/newgroup"}, but the function will fail if the
top level groups do not exists.}
}
\value{
Returns TRUE is group was created successfully and FALSE otherwise.
}
\description{
Creates a group within an HDF5 file.
}
\details{
Creates a new group within an HDF5 file.
}
\examples{

h5createFile("ex_createGroup.h5")

# create groups
h5createGroup("ex_createGroup.h5","foo")
h5createGroup("ex_createGroup.h5","foo/foobaa")

h5ls("ex_createGroup.h5")

}
\seealso{
\code{\link[=h5createFile]{h5createFile()}}, \code{\link[=h5createDataset]{h5createDataset()}},
\code{\link[=h5read]{h5read()}}, \code{\link[=h5write]{h5write()}}
}
\author{
Bernd Fischer
}
