% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h5writeAttr.R
\name{h5_writeAttribute}
\alias{h5_writeAttribute}
\alias{h5writeAttribute}
\alias{h5writeAttribute.array}
\title{Write an R object as an HDF5 attribute}
\usage{
h5writeAttribute(
  attr,
  h5obj,
  name,
  cset = c("ASCII", "UTF8"),
  variableLengthString = FALSE,
  asScalar = FALSE
)

\method{h5writeAttribute}{array}(
  attr,
  h5obj,
  name,
  cset = c("ASCII", "UTF8"),
  variableLengthString = FALSE,
  asScalar = FALSE
)
}
\arguments{
\item{attr}{The R object to be written as an HDF5 attribute.}

\item{h5obj}{An object of class \linkS4class{H5IdComponent} representing a H5
object identifier (file, group, or dataset). See \code{\link{H5Fcreate}},
\code{\link{H5Fopen}}, \code{\link{H5Gcreate}}, \code{\link{H5Gopen}},
\code{\link{H5Dcreate}}, or \code{\link{H5Dopen}} to create an object of
this kind.}

\item{name}{The name of the attribute to be written.}

\item{cset}{The encoding of the string data type.}

\item{variableLengthString}{Whether character vectors should be written as
variable-length strings into the attributes.}

\item{asScalar}{Whether length-1 \code{attr} should be written into a scalar
dataspace.}
}
\description{
Write an R object as an HDF5 attribute
}
