% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H5S.R
\name{H5Screate}
\alias{H5Screate}
\title{Create a new dataspace of a specified type}
\usage{
H5Screate(type = h5default("H5S"), native = FALSE)
}
\arguments{
\item{type}{The type of dataspace to create. See \code{h5const("H5S")} for
possible types.}

\item{native}{An object of class \code{logical}. If \code{TRUE}, array-like
objects are treated as stored in HDF5 row-major rather than R column-major
orientation. Using \code{native = TRUE} increases HDF5 file portability between
programming languages. A file written with \code{native = TRUE} should also be
read with \code{native = TRUE}.}
}
\value{
Returns an object of class \linkS4class{H5IdComponent} representing a
dataspace.
}
\description{
Create a new dataspace of a specified type
}
\seealso{
\link{H5Screate_simple}
}
