% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findPathwaysByXref.R
\name{findPathwaysByXref}
\alias{findPathwaysByXref}
\title{Find Pathways By Xref}
\usage{
findPathwaysByXref(identifier = NULL, systemCode = NULL)
}
\arguments{
\item{identifier}{(\code{character}) The official ID specified by a data 
source or system}

\item{systemCode}{(\code{character}) The BridgeDb code associated with the 
data source or system, 
e.g., En (Ensembl), L (NCBI gene), H (HGNC), U (UniProt), Wd (Wikidata), 
Ce (ChEBI), Ik (InChI). See column two of 
https://github.com/bridgedb/datasources/blob/main/datasources.tsv.}
}
\value{
A \code{dataframe} of pathway attributes including the matching
identifiers
}
\description{
Retrieve pathways containing the query Xref by identifier
 and system code.
}
\examples{
{
findPathwaysByXref('ENSG00000100031','En')
}
}
