% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitLinearModel.R
\name{fitLinearModel}
\alias{fitLinearModel}
\title{Fit a linear model}
\usage{
fitLinearModel(
  x,
  design,
  get.coefs = TRUE,
  subset.row = NULL,
  BPPARAM = SerialParam(),
  rank.error = TRUE
)
}
\arguments{
\item{x}{A numeric matrix-like object where columns are samples (e.g., cells) and rows are usually features (e.g., genes).}

\item{design}{A numeric design matrix with number of rows equal to \code{ncol(x)}.
This should be of full column rank.}

\item{get.coefs}{A logical scalar indicating whether the coefficients should be returned.}

\item{subset.row}{An integer, character or logical vector indicating the rows of \code{x} to use for model fitting.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying the parallelization backend to use.}

\item{rank.error}{Logical scalar indicating whether to throw an error when \code{design} is not of full rank.}
}
\value{
If \code{get.coefs=TRUE}, a list is returned containing:
\itemize{
\item \code{coefficents}, a numeric matrix of coefficient estimates,
with one row per row of \code{x} (or a subset thereof specified by \code{subset.row}) 
and one column per column of \code{design}.
\item \code{mean}, a numeric vector of row means of \code{x}.
Computed as a courtesy to avoid iterating over the matrix twice.
\item \code{variance}, a numeric vector of residual variances per row of \code{x}.
Computed by summing the residual effects from the fitted model.
\item \code{residual.df}, an integer scalar containing the residual degrees of freedom for \code{design}.
}

Otherwise, if \code{get.coefs=FALSE}, the same list is returned without \code{coefficients}.
}
\description{
No-frills fitting of a linear model to the rows of any matrix-like object with numeric values.
}
\details{
This function is basically a stripped-down version of \code{\link{lm.fit}},
made to operate on any matrix representation (ordinary, sparse, whatever).
It is generally intended for use inside other functions that require robust and efficient linear model fitting.

If \code{design} is not of full rank and \code{rank.error=TRUE}, an error is raised.
If \code{rank.error=FALSE}, \code{NA} values are returned for all entries of the output list.
}
\examples{
y <- Matrix::rsparsematrix(1000, 1000, 0.1)
design <- model.matrix(~runif(1000))

output <- fitLinearModel(y, design)
head(output$coefficients)
head(output$variance)

}
\author{
Aaron Lun
}
