% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/pwm.R
\docType{class}
\name{pwm-class}
\alias{pwm-class}
\alias{pwm}
\alias{ic}
\alias{consensus}
\alias{alphabet}
\alias{show,pwm-method}
\alias{summary,pwm-method}
\alias{plot,pwm,ANY-method}
\alias{pwm,pwm-method}
\alias{ic,pwm-method}
\alias{consensus,pwm-method}
\title{An S4 class to represent a PWM matrix.}
\usage{
\S4method{show}{pwm}(object)

\S4method{summary}{pwm}(object, ...)

\S4method{plot}{pwm,ANY}(x, y = "missing", ...)

\S4method{pwm}{pwm}(pwm)

\S4method{ic}{pwm}(pwm)

\S4method{consensus}{pwm}(pwm)
}
\arguments{
\item{object}{object of \code{pwm-class}}

\item{...}{additional parameters for \code{plot} function}

\item{x}{object of \code{pwm-class}}

\item{y}{default (missing) for \code{plot} function}

\item{pwm}{object of \code{pwm-class}}
}
\value{
\code{pwm-class} object with slots: \code{pwm}, \code{width}, \code{ic} and \code{alphabet}.
}
\description{
An object of class \code{'pwm'} represents the alphabet*width
position weight matrix of a sequence motif. In case of DNA sequence motif,
the entry in row i, column j gives the probability of observing nucleotide
\code{c('A','C','G','T')[i]} in position j of the motif.
}
\section{Functions}{
\itemize{
\item \code{show,pwm-method}: Shows the position weight matrix.

\item \code{summary,pwm-method}: Prints the summary information about position weight
matrix.

\item \code{plot,pwm,ANY-method}: Plots the sequence logo of the position weight matrix.

\item \code{pwm,pwm-method}: Access to 'pwm' slot

\item \code{ic,pwm-method}: Access to 'ic' slot

\item \code{consensus,pwm-method}: Access to 'consensus' slot
}}

\section{Slots}{

\describe{
\item{\code{pwm}}{matrix. The position weight matrix.}

\item{\code{width}}{numeric. The width of the motif.}

\item{\code{ic}}{numeric. The information content (IC).}

\item{\code{alphabet}}{character. The sequence alphabet. Currently, only 'DNA' and
'RNA' is supported.}

\item{\code{consensus}}{character. The consensus sequence.}
}}

\examples{
mFile <- system.file("extdata/pwm1", package = "seqLogo")
m <- read.table(mFile)
p <- makePWM(m)
#
# slot access
pwm(p)
ic(p)
consensus(p)
}
\author{
Oliver Bembom
}
