% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colSds,xgCMatrix-method}
\alias{colSds,xgCMatrix-method}
\alias{rowSds,xgCMatrix-method}
\title{Calculates the standard deviation for each row (column) of a matrix-like
object}
\usage{
\S4method{colSds}{xgCMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  center = NULL,
  useNames = TRUE
)

\S4method{rowSds}{xgCMatrix}(
  x,
  rows = NULL,
  cols = NULL,
  na.rm = FALSE,
  center = NULL,
  useNames = TRUE
)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows, cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{na.rm}{If \code{\link[base]{TRUE}}, missing values
(\code{\link[base]{NA}} or \code{\link[base]{NaN}}) are
omitted from the calculations.}

\item{center}{(optional) the center, defaults to the row means}

\item{useNames}{If \code{\link{TRUE}} (default), names attributes of result are set. Else if \code{\link{FALSE}}, no naming support is done.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{vector}} of length N (K).
}
\description{
Calculates the standard deviation for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, \code{\link{table}}, or \code{\link{numeric}} call
\code{matrixStats::\link[matrixStats]{rowSds}} /
\code{matrixStats::\link[matrixStats]{colSds}}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
mat[2, 1] <- NA
mat[3, 3] <- Inf
mat[4, 1] <- 0

print(mat)

rowSds(mat)
colSds(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats]{rowSds}()} and
\code{matrixStats::\link[matrixStats:rowSds]{colSds}()} which are used when
the input is a \code{matrix} or \code{numeric} vector.
\item For mean estimates, see \code{\link[MatrixGenerics]{rowMeans2}()} and
\code{\link[base:colSums]{rowMeans}()}.
\item For variance estimates, see \code{\link[MatrixGenerics]{rowVars}()}.
}
}
