% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdftk.R
\name{pdftk}
\alias{pdftk}
\title{A wrapper for the PDF toolkit Pdftk}
\usage{
pdftk(input, operation = NULL, output, other.opts = "compress dont_ask")
}
\arguments{
\item{input}{the path of the input PDF file(s)}

\item{operation}{the operation to be done on the input (default to be
\code{NULL})}

\item{output}{the path of the output (if missing and \code{input} is a
scalar, \code{output} will be the same as \code{input})}

\item{other.opts}{other options (default to be \code{'compress dont_ask'},
i.e. compress the PDF files and do not ask the user for any input)}
}
\value{
if \code{ani.options('pdftk')} is non-\code{NULL}, then this function
  returns the status of the operation (\code{0} for success; see
  \code{\link{system}}); otherwise a warning will be issued
}
\description{
If the toolkit Pdftk is available in the system, it will be called to
manipulate the PDF files (especially to compress the PDF files).
}
\details{
This is a wrapper to call \command{pdftk}. The path of \command{pdftk} should
be set via \code{\link{ani.options}(pdftk = 'path/to/pdftk')}.

See the reference for detailed usage of \command{pdftk}.
}
\references{
\url{http://www.pdflabs.com/tools/pdftk-the-pdf-toolkit/}
}
\author{
Yihui Xie
}
