% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cause.R
\name{set_cause}
\alias{set_cause}
\title{Set a cause and return the input}
\usage{
set_cause(x, false_value, missing_value = "missing")
}
\arguments{
\item{x}{A variable.}

\item{false_value}{A character vector to set the cause to, where \code{x} is
\code{FALSE}.}

\item{missing_value}{A character vector to set the cause to, where \code{x} is
\code{NA}.}
}
\value{
\code{x}, with a new cause attribute.
}
\description{
Sets the cause attribute of an object and returns that object.
}
\details{
If \code{x} is \code{TRUE} everywhere, this returns the input 
without setting a cause.  Otherwise, the cause is an empty string where 
\code{x} is \code{TRUE}, \code{false_value} where it is \code{FALSE}, and
\code{missing_value} where it is \code{NA}.
}
\seealso{
\code{\link{cause}}, \code{\link[stats]{setNames}}
}

