% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bit.R, R/generics.R
\name{xor.default}
\alias{xor.default}
\alias{xor.logical}
\alias{!.bit}
\alias{&.bit}
\alias{|.bit}
\alias{==.bit}
\alias{!=.bit}
\alias{xor.bit}
\alias{!.bitwhich}
\alias{&.bitwhich}
\alias{|.bitwhich}
\alias{==.bitwhich}
\alias{!=.bitwhich}
\alias{xor.bitwhich}
\alias{&.booltype}
\alias{|.booltype}
\alias{==.booltype}
\alias{!=.booltype}
\alias{xor.booltype}
\alias{xor}
\title{Boolean operators and functions}
\usage{
\method{xor}{default}(x, y)

\method{xor}{logical}(x, y)

\method{!}{bit}(x)

\method{&}{bit}(e1, e2)

\method{|}{bit}(e1, e2)

\method{==}{bit}(e1, e2)

\method{!=}{bit}(e1, e2)

\method{xor}{bit}(x, y)

\method{!}{bitwhich}(x)

\method{&}{bitwhich}(e1, e2)

\method{|}{bitwhich}(e1, e2)

\method{==}{bitwhich}(e1, e2)

\method{!=}{bitwhich}(e1, e2)

\method{xor}{bitwhich}(x, y)

\method{&}{booltype}(e1, e2)

\method{|}{booltype}(e1, e2)

\method{==}{booltype}(e1, e2)

\method{!=}{booltype}(e1, e2)

\method{xor}{booltype}(x, y)

xor(x, y)
}
\arguments{
\item{x}{a \code{\link{is.booltype}} vector}

\item{y}{a \code{\link{is.booltype}} vector}

\item{e1}{a \code{\link{is.booltype}} vector}

\item{e2}{a \code{\link{is.booltype}} vector}
}
\value{
An object of class \code{\link{booltype}} or \code{\link{logical}}
}
\description{
Boolean NEGATION '!', AND '&', OR '|' and EXCLUSIVE OR xor', see \code{\link[base]{Logic}}.
}
\details{
The binary operators and function \code{xor} can now combine any \code{\link{is.booltype}} vectors. 
They now recycle if vectors have different length. If the two arguments have different \code{\link{booltypes}} the return value corresponds to the lower \code{\link{booltype}} of the two. \cr

Boolean operations on \code{\link{bit}} vectors are extremely fast because they are
implemented using C's bitwise operators. Boolean operations on or \code{\link{bitwhich}}  
vectors are even faster, if they represent very skewed selections.  \cr

The \code{xor} function has been made generic and \code{xor.default} has
been implemented much faster than R's standard \code{\link[base:Logic]{xor}}.
This was possible because actually boolean function \code{xor} and
comparison operator \code{!=} do the same (even with NAs), and \code{!=} is
much faster than the multiple calls in \code{(x | y) & !(x & y)}
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: default method for \code{\link{xor}}

\item \code{logical}: \code{\link{logical}} method for \code{\link{xor}}

\item \code{bit}: \code{\link{bit}} method for \code{\link{!}}

\item \code{bit}: \code{\link{bit}} method for \code{\link{&}}

\item \code{bit}: \code{\link{bit}} method for \code{\link{|}}

\item \code{bit}: \code{\link{bit}} method for \code{\link{==}}

\item \code{bit}: \code{\link{bit}} method for \code{\link{!=}}

\item \code{bit}: \code{\link{bit}} method for \code{\link{xor}}

\item \code{bitwhich}: \code{\link{bitwhich}} method for \code{\link{!}}

\item \code{bitwhich}: \code{\link{bitwhich}} method for \code{\link{&}}

\item \code{bitwhich}: \code{\link{bitwhich}} method for \code{\link{|}}

\item \code{bitwhich}: \code{\link{bitwhich}} method for \code{\link{==}}

\item \code{bitwhich}: \code{\link{bitwhich}} method for \code{\link{!=}}

\item \code{bitwhich}: \code{\link{bitwhich}} method for \code{\link{xor}}

\item \code{booltype}: \code{\link{booltype}} method for \code{\link{&}}

\item \code{booltype}: \code{\link{booltype}} method for \code{\link{|}}

\item \code{booltype}: \code{\link{booltype}} method for \code{\link{==}}

\item \code{booltype}: \code{\link{booltype}} method for \code{\link{!=}}

\item \code{booltype}: \code{\link{booltype}} method for \code{\link{xor}}
}}

\examples{

  x <- c(FALSE, FALSE, FALSE, NA, NA, NA, TRUE, TRUE, TRUE)
  y <- c(FALSE, NA, TRUE, FALSE, NA, TRUE, FALSE, NA, TRUE)
  
  x|y
  x|as.bit(y)
  x|as.bitwhich(y)
  x|as.which(y)
  x|ri(1,1,9)
  
  
}
\seealso{
\code{\link{booltypes}}, \code{\link{Logic}}
}
\author{
Jens Oehlschlägel
}
\keyword{classes}
\keyword{logic}
