% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-switch.R
\name{input_switch}
\alias{input_switch}
\alias{update_switch}
\alias{toggle_switch}
\title{Switch input control}
\usage{
input_switch(id, label, value = FALSE, width = NULL)

update_switch(id, label = NULL, value = NULL, session = get_current_session())

toggle_switch(id, value = NULL, session = get_current_session())
}
\arguments{
\item{id}{An input id.}

\item{label}{A label for the switch.}

\item{value}{Whether or not the switch should be checked by default.}

\item{width}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{width="200px"}).}

\item{session}{a shiny session object (the default should almost always be
used).}
}
\value{
Returns a UI element for a switch input control. The server value
received for the input corresponding to \code{id} will be a logical
(\code{TRUE}/\code{FALSE}) value.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Create an on-off style switch control for specifying logical values.
}
\examples{
\dontshow{if (rlang::is_interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(shiny)
library(bslib)

ui <- page_fixed(
  title = "Keyboard Settings",
  h2("Keyboard Settings"),
  input_switch("auto_capitalization", "Auto-Capitalization", TRUE),
  input_switch("auto_correction", "Auto-Correction", TRUE),
  input_switch("check_spelling", "Check Spelling", TRUE),
  input_switch("smart_punctuation", "Smart Punctuation"),
  h2("Preview"),
  verbatimTextOutput("preview")
)

server <- function(input, output, session) {
  output$preview <- renderPrint({
    list(
      auto_capitalization = input$auto_capitalization,
      auto_correction = input$auto_correction,
      check_spelling = input$check_spelling,
      smart_punctuation = input$smart_punctuation
    )
  })
}

shinyApp(ui, server)
\dontshow{\}) # examplesIf}
}
\seealso{
Other input controls: 
\code{\link{input_dark_mode}()}
}
\concept{input controls}
