% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkChoice.R
\name{checkChoice}
\alias{checkChoice}
\alias{check_choice}
\alias{assertChoice}
\alias{assert_choice}
\alias{testChoice}
\alias{test_choice}
\alias{expect_choice}
\title{Check if an object is an element of a given set}
\usage{
checkChoice(x, choices, null.ok = FALSE, fmatch = FALSE)

check_choice(x, choices, null.ok = FALSE, fmatch = FALSE)

assertChoice(
  x,
  choices,
  null.ok = FALSE,
  fmatch = FALSE,
  .var.name = vname(x),
  add = NULL
)

assert_choice(
  x,
  choices,
  null.ok = FALSE,
  fmatch = FALSE,
  .var.name = vname(x),
  add = NULL
)

testChoice(x, choices, null.ok = FALSE, fmatch = FALSE)

test_choice(x, choices, null.ok = FALSE, fmatch = FALSE)

expect_choice(
  x,
  choices,
  null.ok = FALSE,
  fmatch = FALSE,
  info = NULL,
  label = vname(x)
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{choices}{[\code{atomic}]\cr
Set of possible values.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{fmatch}{[\code{logical(1)}]\cr
Use the set operations implemented in \code{\link[fastmatch]{fmatch}} in package \pkg{fastmatch}.
If \pkg{fastmatch} is not installed, this silently falls back to \code{\link[base]{match}}.
\code{\link[fastmatch]{fmatch}} modifies \code{y} by reference:
A hash table is added as attribute which is used in subsequent calls.}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link{vname}}.}

\item{add}{[\code{AssertCollection}]\cr
Collection to store assertion messages. See \code{\link{AssertCollection}}.}

\item{info}{[\code{character(1)}]\cr
Extra information to be included in the message for the testthat reporter.
See \code{\link[testthat]{expect_that}}.}

\item{label}{[\code{character(1)}]\cr
Name of the checked object to print in messages. Defaults to
the heuristic implemented in \code{\link{vname}}.}
}
\value{
Depending on the function prefix:
 If the check is successful, the functions 
 \code{assertChoice}/\code{assert_choice} return 
 \code{x} invisibly, whereas
 \code{checkChoice}/\code{check_choice} and 
 \code{testChoice}/\code{test_choice} return 
 \code{TRUE}.
 If the check is not successful, 
 \code{assertChoice}/\code{assert_choice}
 throws an error message, 
 \code{testChoice}/\code{test_choice}
 returns \code{FALSE},
 and \code{checkChoice}/\code{check_choice} 
 return a string with the error message.
 The function \code{expect_choice} always returns an
 \code{\link[testthat]{expectation}}.
}
\description{
Check if an object is an element of a given set
}
\note{
The object \code{x} must be of the same type as the set w.r.t. \code{\link[base]{typeof}}.
Integers and doubles are both treated as numeric.
}
\examples{
testChoice("x", letters)

# x is not converted before the comparison (except for numerics)
testChoice(factor("a"), "a")
testChoice(1, "1")
testChoice(1, as.integer(1))
}
\seealso{
Other set: 
\code{\link{checkDisjunct}()},
\code{\link{checkPermutation}()},
\code{\link{checkSetEqual}()},
\code{\link{checkSubset}()}
}
\concept{set}
