% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-key.R
\name{check_key}
\alias{check_key}
\title{Check Key}
\usage{
check_key(x, key = character(0), na_distinct = FALSE, x_name = NULL)
}
\arguments{
\item{x}{The object to check.}

\item{key}{A character vector of the columns that represent a unique key.}

\item{na_distinct}{A flag specifying whether missing values should be considered distinct.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
An informative error if the test fails or an invisible copy of x.
}
\description{
Checks if columns have unique rows.
}
\examples{
x <- data.frame(x = c(1, 2), y = c(1, 1))
check_key(x)
try(check_key(x, "y"))
}
\seealso{
Other check: 
\code{\link{check_data}()},
\code{\link{check_dim}()},
\code{\link{check_dirs}()},
\code{\link{check_files}()},
\code{\link{check_names}()},
\code{\link{check_values}()}
}
\concept{check}
