% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chk-not-empty.R
\name{chk_not_empty}
\alias{chk_not_empty}
\alias{vld_not_empty}
\title{Check Not Empty}
\usage{
chk_not_empty(x, x_name = NULL)

vld_not_empty(x)
}
\arguments{
\item{x}{The object to check.}

\item{x_name}{A string of the name of object x or NULL.}
}
\value{
The \code{chk_} function throws an informative error if the test fails or
returns the original object if successful so it can used in pipes.

The \code{vld_} function returns a flag indicating whether the test was met.
}
\description{
Checks if not empty using

\code{length(x) != 0L}

\strong{Pass}: \code{1}, \code{1:2}, \code{NA}, \code{matrix(1:3)}, \code{list(1)}, \code{data.frame(x = 1)}.

\strong{Fail}: \code{NULL}, \code{logical(0)}, \code{list()}, \code{data.frame()}.
}
\section{Functions}{
\itemize{
\item \code{vld_not_empty()}: Validate Not Empty

}}
\examples{
# chk_not_empty
chk_not_empty(1)
try(chk_not_empty(numeric(0)))
# vld_not_empty
vld_not_empty(1)
vld_not_empty(matrix(1:3))
vld_not_empty(character(0))
vld_not_empty(list(1))
vld_not_empty(NULL)
vld_not_empty(list())
}
\seealso{
Other chk_misc: 
\code{\link{chk_length}()},
\code{\link{chk_match}()},
\code{\link{chk_missing}()},
\code{\link{chk_named}()},
\code{\link{chk_not_any_na}()},
\code{\link{chk_not_missing}()},
\code{\link{chk_sorted}()},
\code{\link{chk_unique}()},
\code{\link{chk_valid_name}()}
}
\concept{chk_misc}
