% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utf8.R
\name{utf8_substr}
\alias{utf8_substr}
\title{Substring of an UTF-8 string}
\usage{
utf8_substr(x, start, stop)
}
\arguments{
\item{x}{Character vector.}

\item{start}{Starting index or indices, recycled to match the length
of \code{x}.}

\item{stop}{Ending index or indices, recycled to match the length of
\code{x}.}
}
\value{
Character vector of the same length as \code{x}, containing
the requested substrings.
}
\description{
This function uses grapheme clusters instead of Unicode code points in
UTF-8 strings.
}
\examples{
# Five grapheme clusters, select the middle three
str <- paste0(
  "\U0001f477\U0001f3ff\u200d\u2640\ufe0f",
  "\U0001f477\U0001f3ff",
  "\U0001f477\u200d\u2640\ufe0f",
  "\U0001f477\U0001f3fb",
  "\U0001f477\U0001f3ff")
cat(str)
str24 <- utf8_substr(str, 2, 4)
cat(str24)
}
\seealso{
Other UTF-8 string manipulation: 
\code{\link{utf8_graphemes}()},
\code{\link{utf8_nchar}()}
}
\concept{UTF-8 string manipulation}
