% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vt.R
\name{vt_output}
\alias{vt_output}
\title{Simulate (a subset of) a VT-5xx ANSI terminal}
\usage{
vt_output(output, width = 80L, height = 25L)
}
\arguments{
\item{output}{Character vector or raw vector. Character vectors are
collapsed (without a separater), and converted to a raw vector using
\code{\link[base:rawConversion]{base::charToRaw()}}.}

\item{width}{Terminal width.}

\item{height}{Terminal height.}
}
\value{
Data frame with columns \code{lineno}, \code{segmentno}, \code{segment},
\code{attributes}.
}
\description{
This is utility function that calculates the state of a VT-5xx screen
after a certain set of output.
}
\details{
Currently it supports:
\itemize{
\item configurable terminal width and height
\item ASCII printable characters.
\item \verb{\\n}, \verb{\\r}.
\item ANSI SGR colors, 8 color mode, 256 color mode and true color mode.
\item Other ANSI SGR features: bold, italic, underline, strikethrough,
blink, inverse.
}

It does \emph{not} currently supports other features, mode notably:
\itemize{
\item Other ANSI control sequences and features. Other control sequences
are silently ignored.
\item Wide Unicode characters. Their width is not taken into account
correctly.
\item Unicode graphemes.
}
}
\note{
This function is experimental, and the virtual temrinal API will
likely change in future versions of cli.
}
