% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sys-time.R
\name{as-zoned-time-sys-time}
\alias{as-zoned-time-sys-time}
\alias{as_zoned_time.clock_sys_time}
\title{Convert to a zoned-time from a sys-time}
\usage{
\method{as_zoned_time}{clock_sys_time}(x, zone, ...)
}
\arguments{
\item{x}{\verb{[clock_sys_time]}

A sys-time to convert to a zoned-time.}

\item{zone}{\verb{[character(1)]}

The zone to convert to.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
A zoned-time vector.
}
\description{
This is a sys-time method for the \code{\link[=as_zoned_time]{as_zoned_time()}} generic.

Converting to a zoned-time from a sys-time retains the underlying duration,
but changes the printed time, depending on the \code{zone} that you choose.
Remember that sys-times are interpreted as UTC.

If you want to retain the printed time, try converting to a zoned-time
\link[=as-zoned-time-naive-time]{from a naive-time}, which is a time point
with a yet-to-be-determined time zone.
}
\examples{
x <- as_sys_time(year_month_day(2019, 02, 01, 02, 30, 00))
x

# Since sys-time is interpreted as UTC, converting to a zoned-time with
# a zone of UTC retains the printed time
x_utc <- as_zoned_time(x, "UTC")
x_utc

# Converting to a different zone results in a different printed time,
# which corresponds to the exact same point in time, just in a different
# part of the work
x_ny <- as_zoned_time(x, "America/New_York")
x_ny
}
