% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date-boundary}
\alias{date-boundary}
\alias{date_start.Date}
\alias{date_end.Date}
\title{Boundaries: date}
\usage{
\method{date_start}{Date}(x, precision, ..., invalid = NULL)

\method{date_end}{Date}(x, precision, ..., invalid = NULL)
}
\arguments{
\item{x}{\verb{[Date]}

A date vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"month"}
\item \code{"day"}
}}

\item{...}{These dots are for future extensions and must be empty.}

\item{invalid}{\verb{[character(1) / NULL]}

One of the following invalid date resolution strategies:
\itemize{
\item \code{"previous"}: The previous valid instant in time.
\item \code{"previous-day"}: The previous valid day in time, keeping the time of
day.
\item \code{"next"}: The next valid instant in time.
\item \code{"next-day"}: The next valid day in time, keeping the time of day.
\item \code{"overflow"}: Overflow by the number of days that the input is invalid
by. Time of day is dropped.
\item \code{"overflow-day"}: Overflow by the number of days that the input is
invalid by. Time of day is kept.
\item \code{"NA"}: Replace invalid dates with \code{NA}.
\item \code{"error"}: Error on invalid dates.
}

Using either \code{"previous"} or \code{"next"} is generally recommended, as these
two strategies maintain the \emph{relative ordering} between elements of the
input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{invalid} must be supplied and
cannot be \code{NULL}. This is a convenient way to make production code robust
to invalid dates.}
}
\value{
\code{x} but with some components altered to be at the boundary value.
}
\description{
This is a Date method for the \code{\link[=date_start]{date_start()}} and \code{\link[=date_end]{date_end()}} generics.
}
\examples{
x <- date_build(2019:2021, 2:4, 3:5)
x

# Last day of the month
date_end(x, "month")

# Last day of the year
date_end(x, "year")

# First day of the year
date_start(x, "year")
}
