% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duration.R
\name{duration-arithmetic}
\alias{duration-arithmetic}
\alias{add_years.clock_duration}
\alias{add_quarters.clock_duration}
\alias{add_months.clock_duration}
\alias{add_weeks.clock_duration}
\alias{add_days.clock_duration}
\alias{add_hours.clock_duration}
\alias{add_minutes.clock_duration}
\alias{add_seconds.clock_duration}
\alias{add_milliseconds.clock_duration}
\alias{add_microseconds.clock_duration}
\alias{add_nanoseconds.clock_duration}
\title{Arithmetic: duration}
\usage{
\method{add_years}{clock_duration}(x, n, ...)

\method{add_quarters}{clock_duration}(x, n, ...)

\method{add_months}{clock_duration}(x, n, ...)

\method{add_weeks}{clock_duration}(x, n, ...)

\method{add_days}{clock_duration}(x, n, ...)

\method{add_hours}{clock_duration}(x, n, ...)

\method{add_minutes}{clock_duration}(x, n, ...)

\method{add_seconds}{clock_duration}(x, n, ...)

\method{add_milliseconds}{clock_duration}(x, n, ...)

\method{add_microseconds}{clock_duration}(x, n, ...)

\method{add_nanoseconds}{clock_duration}(x, n, ...)
}
\arguments{
\item{x}{\verb{[clock_duration]}

A duration vector.}

\item{n}{\verb{[integer / clock_duration]}

An integer vector to be converted to a duration, or a duration
corresponding to the arithmetic function being used. This corresponds
to the number of duration units to add. \code{n} may be negative to subtract
units of duration.}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
\code{x} after performing the arithmetic, possibly with a more precise
precision.
}
\description{
These are duration methods for the
\link[=clock-arithmetic]{arithmetic generics}.
\itemize{
\item \code{add_years()}
\item \code{add_quarters()}
\item \code{add_months()}
\item \code{add_weeks()}
\item \code{add_days()}
\item \code{add_hours()}
\item \code{add_minutes()}
\item \code{add_seconds()}
\item \code{add_milliseconds()}
\item \code{add_microseconds()}
\item \code{add_nanoseconds()}
}

When adding to a duration using one of these functions, a second duration
is created based on the function name and \code{n}. The two durations are then
added together, and the precision of the result is determined as the
\emph{more precise precision} of the two durations.
}
\details{
You can add calendrical durations to other calendrical durations,
and chronological durations to other chronological durations, but you can't
add a chronological duration to a calendrical duration
(such as adding days and months). For more information, see the
documentation on the \link[=duration-helper]{duration helper} page.

\code{x} and \code{n} are recycled against each other using
\link[vctrs:theory-faq-recycling]{tidyverse recycling rules}.
}
\examples{
x <- duration_seconds(5)

# Addition in the same precision
add_seconds(x, 1:10)

# Addition with days, defined as 86400 seconds
add_days(x, 1)

# Similarly, if you start with days and add seconds, you get the common
# precision of the two back, which is seconds
y <- duration_days(1)
add_seconds(y, 5)

# But you can't add a chronological duration (days) and
# a calendrical duration (months)
try(add_months(y, 1))

# You can add years to a duration of months, which adds
# an additional 12 months / year
z <- duration_months(5)
add_years(z, 1)
}
