% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_help.R
\name{cmd_help_parse_flags}
\alias{cmd_help_parse_flags}
\title{Parses commandline help options to return vector of valid flag names}
\usage{
cmd_help_parse_flags(help_lines, split_newline = FALSE)
}
\arguments{
\item{help_lines}{\code{character} vector containing the output of "command
--help", or similar output. Optional: pass either \code{stdout}, or \code{stderr} output from
processx::run(), must set \code{processx = TRUE}.}

\item{split_newline}{\code{logical(1)} if set to TRUE will split string on "\\n" before
parsing (useful when parsing output from \code{processx}).}
}
\value{
character vector of flag names parsed from help text
}
\description{
When using cmdfun to write lazy shell wrappers, the user can easily mistype
a commandline flag since there is not text completion. Some programs behave
unexpectedly when flags are typed incorrectly, and for this reason return uninformative error messages.
}
\details{
\code{cmd_help_parse_flags} tries to grab flags from --help documentation which
can be used for error checking. It will try to parse flags following "-" or
"--" while ignoring hyphenated words in help text. Although this should cover
most use-cases, it may be necessary to write a custom help-text parser for
nonstandard tools. Inspect this output \strong{carefully} before proceeding. Most
often, characters are leftover at the \strong{end} of parsed names, which will
require additional parsing.
}
\examples{
if (.Platform$OS.type == "unix" & file.exists("/bin/tar")) {
# below are two examples parsing the --help method of GNU tar 

# with processx
if (require(processx)) {
out <- processx::run("tar", "--help", error_on_status = FALSE)
fn_flags <- cmd_help_parse_flags(out$stdout, split_newline = TRUE)
}

# with system2
lines <- system2("tar", "--help", stderr = TRUE)
fn_flags <- cmd_help_parse_flags(lines)

# NOTE: some of the "tar" flags contain the extra characters: "\\[", "\\)", and ";"
# ie "one-top-level\[" which should be "one-top-level"
# These can be additionally parsed using
gsub("[\\\\[;\\\\)]", "", fn_flags)
}

}
\seealso{
\code{\link{cmd_help_flags_similar}} \code{\link{cmd_help_flags_suggest}}
}
