% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echo.R
\name{curl_echo}
\alias{curl_echo}
\title{Echo Service}
\usage{
curl_echo(handle, port = 9359, progress = interactive(), file = NULL)
}
\arguments{
\item{handle}{a curl handle object}

\item{port}{the port number on which to run httpuv server}

\item{progress}{show progress meter during http transfer}

\item{file}{path or connection to write body. Default returns body as raw vector.}
}
\description{
This function is only for testing purposes. It starts a local httpuv server to
echo the request body and content type in the response.
}
\examples{
h <- handle_setform(new_handle(), foo = "blabla", bar = charToRaw("test"),
myfile = form_file(system.file("DESCRIPTION"), "text/description"))
formdata <- curl_echo(h)

# Show the multipart body
cat(rawToChar(formdata$body))

# Parse multipart
webutils::parse_http(formdata$body, formdata$content_type)
}
