% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_node_clones_ws.R
\name{add_node_clones_ws}
\alias{add_node_clones_ws}
\title{Add clones of a selection of nodes}
\usage{
add_node_clones_ws(graph, add_edges = FALSE, direction = NULL, label = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{add_edges}{An option for whether to add edges from the selected nodes
to each of their clones, or, in the opposite direction.}

\item{direction}{Using \code{from} will create new edges from existing nodes to
the new, cloned nodes. The \code{to} option will create new edges directed
toward the existing nodes.}

\item{label}{An optional vector of node label values. The vector length
should correspond to the number of nodes in the active selection of nodes.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Add new nodes to a graph object of class \code{dgr_graph} which are clones of
nodes in an active selection of nodes. All node attributes are preserved
except for the node \code{label} attribute (to maintain the uniqueness of non-\code{NA}
node label values). A vector of node \code{label} can be provided to bind new
labels to the cloned nodes.

This function makes use of an active selection of nodes (and the function
ending with \verb{_ws} hints at this).

Selections of nodes can be performed using the following node selection
(\verb{select_*()}) functions: \code{\link[=select_nodes]{select_nodes()}}, \code{\link[=select_last_nodes_created]{select_last_nodes_created()}},
\code{\link[=select_nodes_by_degree]{select_nodes_by_degree()}}, \code{\link[=select_nodes_by_id]{select_nodes_by_id()}}, or
\code{\link[=select_nodes_in_neighborhood]{select_nodes_in_neighborhood()}}.

Selections of nodes can also be performed using the following traversal
(\verb{trav_*()}) functions: \code{\link[=trav_out]{trav_out()}}, \code{\link[=trav_in]{trav_in()}}, \code{\link[=trav_both]{trav_both()}},
\code{\link[=trav_out_node]{trav_out_node()}}, \code{\link[=trav_in_node]{trav_in_node()}}, \code{\link[=trav_out_until]{trav_out_until()}}, or
\code{\link[=trav_in_until]{trav_in_until()}}.
}
\examples{
# Create a graph with a path of
# nodes; supply `label`, `type`,
# and `value` node attributes,
# and select the created nodes
graph <-
  create_graph() \%>\%
  add_path(
    n = 3,
    label = c("d", "g", "r"),
    type = c("a", "b", "c")) \%>\%
  select_last_nodes_created()

# Display the graph's internal
# node data frame
graph \%>\% get_node_df()

# Create clones of all nodes
# in the selection but assign
# new node label values
# (leaving `label` as NULL
# yields NA values)
graph <-
  graph \%>\%
  add_node_clones_ws(
    label = c("a", "b", "v"))

# Display the graph's internal
# node data frame: nodes `4`,
# `5`, and `6` are clones of
# `1`, `2`, and `3`
graph \%>\% get_node_df()

# Select the last nodes
# created (`4`, `5`, and `6`)
# and clone those nodes and
# their attributes while
# creating new edges between
# the new and existing nodes
graph <-
  graph \%>\%
  select_last_nodes_created() \%>\%
  add_node_clones_ws(
    add_edges = TRUE,
    direction = "to",
    label = c("t", "z", "s"))

# Display the graph's internal
# edge data frame; there are
# edges between the selected
# nodes and their clones
graph \%>\% get_edge_df()

}
\seealso{
Other node creation and removal: 
\code{\link{add_n_node_clones}()},
\code{\link{add_n_nodes}()},
\code{\link{add_n_nodes_ws}()},
\code{\link{add_node}()},
\code{\link{add_node_df}()},
\code{\link{add_nodes_from_df_cols}()},
\code{\link{add_nodes_from_table}()},
\code{\link{colorize_node_attrs}()},
\code{\link{copy_node_attrs}()},
\code{\link{create_node_df}()},
\code{\link{delete_node}()},
\code{\link{delete_nodes_ws}()},
\code{\link{drop_node_attrs}()},
\code{\link{join_node_attrs}()},
\code{\link{layout_nodes_w_string}()},
\code{\link{mutate_node_attrs}()},
\code{\link{mutate_node_attrs_ws}()},
\code{\link{node_data}()},
\code{\link{recode_node_attrs}()},
\code{\link{rename_node_attrs}()},
\code{\link{rescale_node_attrs}()},
\code{\link{set_node_attr_to_display}()},
\code{\link{set_node_attr_w_fcn}()},
\code{\link{set_node_attrs}()},
\code{\link{set_node_attrs_ws}()},
\code{\link{set_node_position}()}
}
\concept{node creation and removal}
