% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_graph_time.R
\name{set_graph_time}
\alias{set_graph_time}
\title{Set graph date-time and timezone}
\usage{
set_graph_time(graph, time = NULL, tz = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{time}{The date-time to set for the graph.}

\item{tz}{The timezone to set for the graph.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
Set the time and timezone for a graph object of class \code{dgr_graph}.
}
\examples{
# Create an empty graph
graph <- create_graph()

# Provide the new graph with a timestamp (if `tz`
# is not supplied, `GMT` is used as the time zone)
graph_1 <-
  graph \%>\%
  set_graph_time(time = "2015-10-25 15:23:00")

# Provide the new graph with a timestamp that is
# the current time; the time zone is inferred from
# the user's locale
graph_2 <-
  graph \%>\%
  set_graph_time()

# The time zone can be updated when a timestamp
# is present
graph_2 <-
  graph_2 \%>\%
  set_graph_time(tz = "America/Los_Angeles")

}
