% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimRedMethod-class.R
\docType{class}
\name{dimRedMethod-class}
\alias{dimRedMethod-class}
\title{Class "dimRedMethod"}
\description{
A virtual class "dimRedMethod" to serve as a template to implement
methods for dimensionality reduction.
}
\details{
Implementations of dimensionality reductions should inherit from
this class.

The \code{fun} slot should be a function that takes three arguments
\describe{
  \item{data}{An object of class \code{\link{dimRedData}}.}
  \item{pars}{A list with the standard parameters.}
  \item{keep.org.data}{Logical. If the original data should be kept in the output.}
}
and returns an object of class \code{\link{dimRedResult}}.

The \code{stdpars} slot should take a list that contains standard
parameters for the implemented methods.

This way the method can be called by \code{embed(data,
"method-name", ...)}, where \code{...} can be used to to change
single parameters.
}
\section{Slots}{

\describe{
\item{\code{fun}}{A function that does the embedding.}

\item{\code{stdpars}}{A list with the default parameters for the \code{fun}
slot.}
}}

\seealso{
\link{dimRedMethodList}

Other dimensionality reduction methods: \code{\link{DRR-class}},
  \code{\link{DiffusionMaps-class}},
  \code{\link{DrL-class}}, \code{\link{FastICA-class}},
  \code{\link{FruchtermanReingold-class}},
  \code{\link{HLLE-class}}, \code{\link{Isomap-class}},
  \code{\link{KamadaKawai-class}}, \code{\link{LLE-class}},
  \code{\link{MDS-class}}, \code{\link{PCA-class}},
  \code{\link{kPCA-class}}, \code{\link{nMDS-class}},
  \code{\link{tSNE-class}}
}
