% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_uniform.R
\name{dist_uniform}
\alias{dist_uniform}
\title{The Uniform distribution}
\usage{
dist_uniform(min, max)
}
\arguments{
\item{min}{lower and upper limits of the distribution.  Must be finite.}

\item{max}{lower and upper limits of the distribution.  Must be finite.}
}
\description{
\lifecycle{stable}
}
\details{
A distribution with constant density on an interval.

We recommend reading this documentation on
\url{https://pkg.mitchelloharawild.com/distributional/}, where the math
will render nicely.

In the following, let \eqn{X} be a Poisson random variable with parameter
\code{lambda} = \eqn{\lambda}.

\strong{Support}: \eqn{[a,b]}{[a,b]}

\strong{Mean}: \eqn{\frac{1}{2}(a+b)}

\strong{Variance}: \eqn{\frac{1}{12}(b-a)^2}

\strong{Probability mass function (p.m.f)}:

\deqn{
    f(x) = \frac{1}{b-a} for x \in [a,b]
  }{
    f(x) = \frac{1}{b-a} for x in [a,b]
  }
\deqn{
    f(x) = 0 otherwise
  }{
    f(x) = 0 otherwise
  }

\strong{Cumulative distribution function (c.d.f)}:

\deqn{
    F(x) = 0 for x < a
  }{
    F(x) = 0 for x < a
  }
\deqn{
    F(x) = \frac{x - a}{b-a} for x \in [a,b]
  }{
    F(x) = \frac{x - a}{b-a} for x in [a,b]
  }
\deqn{
    F(x) = 1 for x > b
  }{
    F(x) = 1 for x > b
  }

\strong{Moment generating function (m.g.f)}:

\deqn{
    E(e^{tX}) = \frac{e^{tb} - e^{ta}}{t(b-a)} for t \neq 0
  }{
    E(e^(tX)) = \frac{e^{tb} - e^{ta}}{t(b-a)} for t \neq 0
  }
\deqn{
    E(e^{tX}) = 1 for t = 0
  }{
    E(e^(tX)) = 1 for t = 0
  }
}
\examples{
dist <- dist_uniform(min = c(3, -2), max = c(5, 4))

dist
mean(dist)
variance(dist)
skewness(dist)
kurtosis(dist)

generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)

}
\seealso{
\link[stats:Uniform]{stats::Uniform}
}
