% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgc.R
\name{pgc}
\alias{pgc}
\title{Preparing weight for GENECOUNTING}
\usage{
pgc(data, handle.miss = 1, is.genotype = 0, with.id = 0)
}
\arguments{
\item{data}{the multilocus genotype data for a set of individuals.}

\item{handle.miss}{a flag to indicate if missing data is kept, 0 = no, 1 = yes.}

\item{is.genotype}{a flag to indicate if the data is already in the form of genotype identifiers.}

\item{with.id}{a flag to indicate if the unique multilocus genotype identifier is generated.}
}
\value{
The returned value is a list containing:
\itemize{
\item cdata the collapsed genotype data.
\item wt the frequency weight.
\item obscom the observed number of combinations or genotypes.
\item idsave optional, available only if with.id = 1.
}
}
\description{
Preparing weight for GENECOUNTING
}
\details{
This function is a R port of the GENECOUNTING/PREPARE program which takes
an array of genotyep data and collapses individuals with the same multilocus
genotype. This function can also be used to prepare for the genotype table in testing
Hardy-Weinberg equilibrium.
}
\note{
Built on pgc.c.
}
\examples{
\dontrun{
require(gap.datasets)
data(hla)
x <- hla[,3:8]

# do not handle missing data
y<-pgc(x,handle.miss=0,with.id=1)
hla.gc<-genecounting(y$cdata,y$wt)

# handle missing but with multilocus genotype identifier
pgc(x,handle.miss=1,with.id=1)

# handle missing data with no identifier
pgc(x,handle.miss=1,with.id=0)
}

}
\references{
\insertRef{zhao03}{gap}
}
\seealso{
\code{\link{genecounting}}, \code{\link{hwe.hardy}}
}
\author{
Jing Hua Zhao
}
\keyword{utilities}
