% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/renderers.R
\name{video_file}
\alias{video_file}
\alias{print.video_file}
\alias{knit_print.video_file}
\title{Wrap a video file for easy handling}
\usage{
video_file(file)

\method{print}{video_file}(x, width = NULL, ...)

knit_print.video_file(x, options, ...)
}
\arguments{
\item{file}{A video file}

\item{x}{A \code{video_file} object}

\item{width}{The width the output should be scaled to}

\item{...}{Arguments passed on}
}
\value{
\code{video_file} returns a \code{video_file} object which is a shallow wrapper
around the file path text string.
}
\description{
This function is equivalent to \code{\link[=gif_file]{gif_file()}} but works for arbitrary video
file formats. There are some caveats involved though, most notably it doesn't
currently supports splitting so you can't easily use this output together
with \code{\link[=split_animation]{split_animation()}}. Graceful printing is contingent on the file format.
Only \code{mp4}, \code{webm}, and \code{ogg} is supported by the HTML format and can thus be
shown in the RStudio viewer and inside HTML documents created with knitr.
Other formats will be opened in their default OS-specific viewer.
}
\keyword{internal}
