% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov.R
\name{vcov}
\alias{vcov}
\alias{vcov.ggeffects}
\title{Calculate variance-covariance matrix for marginal effects}
\usage{
\method{vcov}{ggeffects}(object, vcov.fun = NULL, vcov.type = NULL, vcov.args = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{"ggeffects"}, as returned by \code{ggpredict()}.}

\item{vcov.fun}{String, indicating the name of the \code{vcov*()}-function
from the \pkg{sandwich} or \pkg{clubSandwich}-package, e.g.
\code{vcov.fun = "vcovCL"}, which is used to compute (cluster) robust
standard errors for predictions. If \code{NULL}, standard errors (and
confidence intervals) for predictions are based on the standard errors as
returned by the \code{predict()}-function. \strong{Note} that probably not
all model objects that work with \code{ggpredict()} are also supported
by the \pkg{sandwich} or \pkg{clubSandwich}-package.}

\item{vcov.type}{Character vector, specifying the estimation type for the
robust covariance matrix estimation (see \code{\link[sandwich]{vcovHC}}
or \code{\link[clubSandwich]{vcovCR}} for details).}

\item{vcov.args}{List of named vectors, used as additional arguments that
are passed down to \code{vcov.fun}.}

\item{...}{Currently not used.}
}
\value{
The variance-covariance matrix for the predicted values from \code{object}.
}
\description{
Returns the variance-covariance matrix for the predicted values from \code{object}.
}
\details{
The returned matrix has as many rows (and columns) as possible combinations
  of predicted values from the \code{ggpredict()} call. For example, if there
  are two variables in the \code{terms}-argument of \code{ggpredict()} with 3 and 4
  levels each, there will be 3*4 combinations of predicted values, so the returned
  matrix has a 12x12 dimension. In short, \code{nrow(object)} is always equal to
  \code{nrow(vcov(object))}. See also 'Examples'.
}
\examples{
data(efc)
model <- lm(barthtot ~ c12hour + neg_c_7 + c161sex + c172code, data = efc)
result <- ggpredict(model, c("c12hour [meansd]", "c161sex"))

vcov(result)

# compare standard errors
sqrt(diag(vcov(result)))
as.data.frame(result)

# only two predicted values, no further terms
# vcov() returns a 2x2 matrix
result <- ggpredict(model, "c161sex")
vcov(result)

# 2 levels for c161sex multiplied by 3 levels for c172code
# result in 6 combinations of predicted values
# thus vcov() returns a 6x6 matrix
result <- ggpredict(model, c("c161sex", "c172code"))
vcov(result)

}
