% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install_latest.R
\name{install_latest}
\alias{install_latest}
\title{Update latest ggeffects-version from R-universe (GitHub) or CRAN}
\usage{
install_latest(
  source = c("development", "cran"),
  force = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{source}{Character. Either \code{"development"} or \code{"cran"}. If \code{"cran"},
\emph{ggeffects} will be installed from the default CRAN mirror returned by
\code{getOption("repos")['CRAN']}. If \code{"development"} (the default), \emph{ggeffects}
is installed from the r-universe repository (\url{https://strengejacke.r-universe.dev/}).}

\item{force}{Logical, if \code{FALSE}, the update will only be installed if a newer
version is available. Use \code{force=TRUE} to force installation, even if the
version number for the locally installed package is identical to the latest
development-version. Only applies when \code{source="development"}.}

\item{verbose}{Toggle messages.}
}
\value{
Invisible \code{NULL}.
}
\description{
This function can be used to install the latest package version of \emph{ggeffects},
either the development version (from R-universe/GitHub) or the current
version from CRAN.
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# install latest development-version of ggeffects from the
# r-universe repository
install_latest()
\dontshow{\}) # examplesIf}
}
