% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aes.r
\name{aes_}
\alias{aes_}
\alias{aes_string}
\alias{aes_q}
\title{Define aesthetic mappings programatically}
\usage{
aes_(x, y, ...)

aes_string(x, y, ...)

aes_q(x, y, ...)
}
\arguments{
\item{x, y, ...}{List of name value pairs. Elements must be either
quoted calls, strings, one-sided formulas or constants.}
}
\description{
Aesthetic mappings describe how variables in the data are mapped to visual
properties (aesthetics) of geoms. \code{\link{aes}} uses non-standard
evaluation to capture the variable names. \code{aes_} and \code{aes_string}
require you to explicitly quote the inputs either with \code{""} for
\code{aes_string()}, or with \code{quote} or \code{~} for \code{aes_()}.
(\code{aes_q} is an alias to \code{aes_}). This makes \code{aes_} and
\code{aes_string} easy to program with.
}
\details{
\code{aes_string} and \code{aes_} are particularly useful when writing
functions that create plots because you can use strings or quoted
names/calls to define the aesthetic mappings, rather than having to use
\code{\link{substitute}} to generate a call to \code{aes()}.

I recommend using \code{aes_()}, because creating the equivalents of
\code{aes(colour = "my colour")} or \code{aes{x = `X$1`}}
with \code{aes_string()} is quite clunky.
}
\examples{
# Three ways of generating the same aesthetics
aes(mpg, wt, col = cyl)
aes_(quote(mpg), quote(wt), col = quote(cyl))
aes_(~mpg, ~wt, col = ~cyl)
aes_string("mpg", "wt", col = "cyl")

# You can't easily mimic these calls with aes_string
aes(`$100`, colour = "smooth")
aes_(~ `$100`, colour = "smooth")
# Ok, you can, but it requires a _lot_ of quotes
aes_string("`$100`", colour = '"smooth"')

# Convert strings to names with as.name
var <- "cyl"
aes(col = x)
aes_(col = as.name(var))
}
\seealso{
\code{\link{aes}}
}
