% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.r
\name{remove_missing}
\alias{remove_missing}
\title{Convenience function to remove missing values from a data.frame}
\usage{
remove_missing(df, na.rm = FALSE, vars = names(df), name = "",
  finite = FALSE)
}
\arguments{
\item{df}{data.frame}

\item{na.rm}{If true, will suppress warning message.}

\item{vars}{Character vector of variables to check for missings in}

\item{name}{Optional function name to improve error message.}

\item{finite}{If \code{TRUE}, will also remove non-finite values.}
}
\description{
Remove all non-complete rows, with a warning if \code{na.rm = FALSE}.
ggplot is somewhat more accommodating of missing values than R generally.
For those stats which require complete data, missing values will be
automatically removed with a warning. If \code{na.rm = TRUE} is supplied
to the statistic, the warning will be suppressed.
}
\keyword{internal}
