% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.r
\name{theme}
\alias{theme}
\title{Modify components of a theme}
\usage{
theme(line, rect, text, title, aspect.ratio, axis.title, axis.title.x,
  axis.title.x.top, axis.title.y, axis.title.y.right, axis.text, axis.text.x,
  axis.text.x.top, axis.text.y, axis.text.y.right, axis.ticks, axis.ticks.x,
  axis.ticks.y, axis.ticks.length, axis.line, axis.line.x, axis.line.y,
  legend.background, legend.margin, legend.spacing, legend.spacing.x,
  legend.spacing.y, legend.key, legend.key.size, legend.key.height,
  legend.key.width, legend.text, legend.text.align, legend.title,
  legend.title.align, legend.position, legend.direction, legend.justification,
  legend.box, legend.box.just, legend.box.margin, legend.box.background,
  legend.box.spacing, panel.background, panel.border, panel.spacing,
  panel.spacing.x, panel.spacing.y, panel.grid, panel.grid.major,
  panel.grid.minor, panel.grid.major.x, panel.grid.major.y, panel.grid.minor.x,
  panel.grid.minor.y, panel.ontop, plot.background, plot.title, plot.subtitle,
  plot.caption, plot.margin, strip.background, strip.placement, strip.text,
  strip.text.x, strip.text.y, strip.switch.pad.grid, strip.switch.pad.wrap, ...,
  complete = FALSE, validate = TRUE)
}
\arguments{
\item{line}{all line elements (\code{element_line})}

\item{rect}{all rectangular elements (\code{element_rect})}

\item{text}{all text elements (\code{element_text})}

\item{title}{all title elements: plot, axes, legends (\code{element_text};
inherits from \code{text})}

\item{aspect.ratio}{aspect ratio of the panel}

\item{axis.title}{label of axes (\code{element_text}; inherits from
\code{text})}

\item{axis.title.x}{x axis label (\code{element_text}; inherits from
\code{axis.title})}

\item{axis.title.x.top}{x axis label on top axis (\code{element_text};
inherits from \code{axis.title.x})}

\item{axis.title.y}{y axis label (\code{element_text}; inherits from
\code{axis.title})}

\item{axis.title.y.right}{y axis label on right axis (\code{element_text};
inherits from \code{axis.title.y})}

\item{axis.text}{tick labels along axes (\code{element_text}; inherits from
\code{text})}

\item{axis.text.x}{x axis tick labels (\code{element_text}; inherits from
\code{axis.text})}

\item{axis.text.x.top}{x axis tick labels on top axis (\code{element_text};
inherits from \code{axis.text.x})}

\item{axis.text.y}{y axis tick labels (\code{element_text}; inherits from
\code{axis.text})}

\item{axis.text.y.right}{y axis tick labels on right axis
(\code{element_text}; inherits from \code{axis.text.y})}

\item{axis.ticks}{tick marks along axes (\code{element_line}; inherits from
\code{line})}

\item{axis.ticks.x}{x axis tick marks (\code{element_line}; inherits from
\code{axis.ticks})}

\item{axis.ticks.y}{y axis tick marks (\code{element_line}; inherits from
\code{axis.ticks})}

\item{axis.ticks.length}{length of tick marks (\code{unit})}

\item{axis.line}{lines along axes (\code{element_line}; inherits from
\code{line})}

\item{axis.line.x}{line along x axis (\code{element_line}; inherits from
\code{axis.line})}

\item{axis.line.y}{line along y axis (\code{element_line}; inherits from
\code{axis.line})}

\item{legend.background}{background of legend (\code{element_rect}; inherits
from \code{rect})}

\item{legend.margin}{the margin around each legend (\code{margin})}

\item{legend.spacing}{the spacing between legends (\code{unit})}

\item{legend.spacing.x}{the horizontal spacing between legends (\code{unit});
inherits from \code{legend.spacing}}

\item{legend.spacing.y}{the horizontal spacing between legends (\code{unit});
inherits from \code{legend.spacing}}

\item{legend.key}{background underneath legend keys (\code{element_rect};
inherits from \code{rect})}

\item{legend.key.size}{size of legend keys (\code{unit})}

\item{legend.key.height}{key background height (\code{unit}; inherits from
\code{legend.key.size})}

\item{legend.key.width}{key background width (\code{unit}; inherits from
\code{legend.key.size})}

\item{legend.text}{legend item labels (\code{element_text}; inherits from
\code{text})}

\item{legend.text.align}{alignment of legend labels (number from 0 (left) to
1 (right))}

\item{legend.title}{title of legend (\code{element_text}; inherits from
\code{title})}

\item{legend.title.align}{alignment of legend title (number from 0 (left) to
1 (right))}

\item{legend.position}{the position of legends ("none", "left", "right",
"bottom", "top", or two-element numeric vector)}

\item{legend.direction}{layout of items in legends ("horizontal" or
"vertical")}

\item{legend.justification}{anchor point for positioning legend inside plot
("center" or two-element numeric vector) or the justification according to
the plot area when positioned outside the plot}

\item{legend.box}{arrangement of multiple legends ("horizontal" or
"vertical")}

\item{legend.box.just}{justification of each legend within the overall
bounding box, when there are multiple legends ("top", "bottom", "left", or
"right")}

\item{legend.box.margin}{margins around the full legend area, as specified
using \code{\link{margin}}}

\item{legend.box.background}{background of legend area (\code{element_rect};
inherits from \code{rect})}

\item{legend.box.spacing}{The spacing between the plotting area and the
legend box (\code{unit})}

\item{panel.background}{background of plotting area, drawn underneath plot
(\code{element_rect}; inherits from \code{rect})}

\item{panel.border}{border around plotting area, drawn on top of plot so that
  it covers tick marks and grid lines. This should be used with
  \code{fill=NA}
(\code{element_rect}; inherits from \code{rect})}

\item{panel.spacing}{spacing between facet panels (\code{unit})}

\item{panel.spacing.x}{horizontal spacing between facet panels (\code{unit};
inherits from \code{panel.spacing})}

\item{panel.spacing.y}{vertical spacing between facet panels (\code{unit};
inherits from \code{panel.spacing})}

\item{panel.grid}{grid lines (\code{element_line}; inherits from \code{line})}

\item{panel.grid.major}{major grid lines (\code{element_line}; inherits from
\code{panel.grid})}

\item{panel.grid.minor}{minor grid lines (\code{element_line}; inherits from
\code{panel.grid})}

\item{panel.grid.major.x}{vertical major grid lines (\code{element_line};
inherits from \code{panel.grid.major})}

\item{panel.grid.major.y}{horizontal major grid lines (\code{element_line};
inherits from \code{panel.grid.major})}

\item{panel.grid.minor.x}{vertical minor grid lines (\code{element_line};
inherits from \code{panel.grid.minor})}

\item{panel.grid.minor.y}{horizontal minor grid lines (\code{element_line};
inherits from \code{panel.grid.minor})}

\item{panel.ontop}{option to place the panel (background, gridlines) over
the data layers.  Usually used with a transparent or blank
\code{panel.background}. (\code{logical})}

\item{plot.background}{background of the entire plot (\code{element_rect};
inherits from \code{rect})}

\item{plot.title}{plot title (text appearance) (\code{element_text}; inherits
from \code{title}) left-aligned by default}

\item{plot.subtitle}{plot subtitle (text appearance) (\code{element_text};
inherits from \code{title}) left-aligned by default}

\item{plot.caption}{caption below the plot (text appearance)
(\code{element_text}; inherits from \code{title}) right-aligned by default}

\item{plot.margin}{margin around entire plot (\code{unit} with the sizes of
the top, right, bottom, and left margins)}

\item{strip.background}{background of facet labels (\code{element_rect};
inherits from \code{rect})}

\item{strip.placement}{placement of strip with respect to axes,
either "inside" or "outside". Only important when axes and strips are
on the same side of the plot.}

\item{strip.text}{facet labels (\code{element_text}; inherits from
\code{text})}

\item{strip.text.x}{facet labels along horizontal direction
(\code{element_text}; inherits from \code{strip.text})}

\item{strip.text.y}{facet labels along vertical direction
(\code{element_text}; inherits from \code{strip.text})}

\item{strip.switch.pad.grid}{space between strips and axes when strips are
switched (\code{unit})}

\item{strip.switch.pad.wrap}{space between strips and axes when strips are
switched (\code{unit})}

\item{...}{additional element specifications not part of base ggplot2. If
supplied \code{validate} needs to be set to \code{FALSE}.}

\item{complete}{set this to TRUE if this is a complete theme, such as
the one returned \code{by theme_grey()}. Complete themes behave
differently when added to a ggplot object. Also, when setting
\code{complete = TRUE} all elements will be set to inherit from blank
elements.}

\item{validate}{\code{TRUE} to run validate_element, \code{FALSE} to bypass checks.}
}
\description{
Use \code{theme()} to modify individual components of a theme, allowing
you to control the appearance of all non-data components of the plot.
\code{theme()} only affects a single plot: see \code{\link{theme_update}} if
you want modify the active theme, to affect all subsequent plots.
}
\section{Theme inheritance}{

Theme elements inherit properties from other theme elements.
For example, \code{axis.title.x} inherits from \code{axis.title},
which in turn inherits from \code{text}. All text elements inherit
directly or indirectly from \code{text}; all lines inherit from
\code{line}, and all rectangular objects inherit from \code{rect}.
This means that you can modify the appearance of multiple elements by
setting a single high-level component.
}

\examples{
p1 <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point() +
  labs(title = "Fuel economy declines as weight increases")
p1

# Plot ---------------------------------------------------------------------
p1 + theme(plot.title = element_text(size = rel(2)))
p1 + theme(plot.background = element_rect(fill = "green"))

# Panels --------------------------------------------------------------------

p1 + theme(panel.background = element_rect(fill = "white", colour = "grey50"))
p1 + theme(panel.border = element_rect(linetype = "dashed", fill = NA))
p1 + theme(panel.grid.major = element_line(colour = "black"))
p1 + theme(
  panel.grid.major.y = element_blank(),
  panel.grid.minor.y = element_blank()
)

# Put gridlines on top of data
p1 + theme(
  panel.background = element_rect(fill = NA),
  panel.grid.major = element_line(colour = "grey50"),
  panel.ontop = TRUE
)

# Axes ----------------------------------------------------------------------
p1 + theme(axis.line = element_line(size = 3, colour = "grey80"))
p1 + theme(axis.text = element_text(colour = "blue"))
p1 + theme(axis.ticks = element_line(size = 2))
p1 + theme(axis.ticks.length = unit(.25, "cm"))
p1 + theme(axis.title.y = element_text(size = rel(1.5), angle = 90))

\donttest{
# Legend --------------------------------------------------------------------
p2 <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point(aes(colour = factor(cyl), shape = factor(vs))) +
  labs(
    x = "Weight (1000 lbs)",
    y = "Fuel economy (mpg)",
    colour = "Cylinders",
    shape = "Transmission"
   )
p2

# Position
p2 + theme(legend.position = "none")
p2 + theme(legend.justification = "top")
p2 + theme(legend.position = "bottom")

# Or place inside the plot using relative coordinates between 0 and 1
# legend.justification sets the corner that the position refers to
p2 + theme(
  legend.position = c(.95, .95),
  legend.justification = c("right", "top"),
  legend.box.just = "right",
  legend.margin = margin(6, 6, 6, 6)
)

# The legend.box properties work similarly for the space around
# all the legends
p2 + theme(
  legend.box.background = element_rect(),
  legend.box.margin = margin(6, 6, 6, 6)
)

# You can also control the display of the keys
# and the justifaction related to the plot area can be set
p2 + theme(legend.key = element_rect(fill = "white", colour = "black"))
p2 + theme(legend.text = element_text(size = 8, colour = "red"))
p2 + theme(legend.title = element_text(face = "bold"))

# Strips --------------------------------------------------------------------

p3 <- ggplot(mtcars, aes(wt, mpg)) +
  geom_point() +
  facet_wrap(~ cyl)
p3

p3 + theme(strip.background = element_rect(colour = "black", fill = "white"))
p3 + theme(strip.text.x = element_text(colour = "white", face = "bold"))
p3 + theme(panel.spacing = unit(1, "lines"))
}
}
\seealso{
\code{\link{+.gg}} and \code{\link{\%+replace\%}},
  \code{\link{element_blank}}, \code{\link{element_line}},
  \code{\link{element_rect}}, and \code{\link{element_text}} for
  details of the specific theme elements.
}
