% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-simpsons.R
\name{pal_simpsons}
\alias{pal_simpsons}
\title{The Simpsons color palettes}
\usage{
pal_simpsons(palette = c("springfield"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
Currently there is one available option: \code{"springfield"}
(16-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices:rgb]{grDevices::rgb()}} for details.}
}
\description{
Color palettes inspired by the colors used in \emph{The Simpsons}.
}
\examples{
library("scales")
show_col(pal_simpsons("springfield")(16))
show_col(pal_simpsons("springfield", alpha = 0.6)(16))
}
\author{
Nan Xiao | \email{me@nanx.me} | \url{https://nanx.me}
}
