% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_drives.R
\name{as_shared_drive}
\alias{as_shared_drive}
\title{Coerce to shared drive}
\usage{
as_shared_drive(x, ...)
}
\arguments{
\item{x}{A vector of shared drive names, a vector of shared drive ids marked
with \code{\link[=as_id]{as_id()}}, a list of Drives resource objects, or a suitable data
frame.}

\item{...}{Other arguments passed down to methods. (Not used.)}
}
\description{
Converts various representations of a shared drive into a
\code{\link{dribble}}, the object used by googledrive to hold Drive file metadata.
Shared drives can be specified via
\itemize{
\item Name
\item Shared drive id, marked with \code{\link[=as_id]{as_id()}} to distinguish from name
\item Data frame or \code{\link{dribble}} consisting solely of shared drives
\item List representing \href{https://developers.google.com/drive/api/v3/reference/drives#resource-representations}{Drives resource}
objects (mostly for internal use)
}

A shared drive supports files owned by an organization rather than an
individual user. Shared drives follow different sharing and ownership models
from a specific user's "My Drive". Shared drives are the successors to the
earlier concept of Team Drives. Learn more about \link[=shared_drives]{shared drives}.

This is a generic function.
}
\examples{
\dontrun{
# specify the name
as_shared_drive("abc")

# specify the id (substitute one of your own!)
as_shared_drive(as_id("0AOPK1X2jaNckUk9PVA"))
}
}
