% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlwidgets.R
\name{onRender}
\alias{onRender}
\title{Execute custom JavaScript code after rendering}
\usage{
onRender(x, jsCode, data = NULL)
}
\arguments{
\item{x}{An HTML Widget object}

\item{jsCode}{Character vector containing JavaScript code (see Details)}

\item{data}{An additional argument to pass to the \code{jsCode} function.
This can be any R object that can be serialized to JSON. If you have
multiple objects to pass to the function, use a named list.}
}
\value{
The modified widget object
}
\description{
Use this function to supplement the widget's built-in JavaScript rendering
logic with additional custom JavaScript code, just for this specific widget
object.
}
\details{
The \code{jsCode} parameter must contain valid JavaScript code which
  when evaluated returns a function.

  The function will be invoked with three arguments: the first is the widget's
  main HTML element, and the second is the data to be rendered (the \code{x}
  parameter in \code{createWidget}). The third argument is the JavaScript
  equivalent of the R object passed into \code{onRender} as the \code{data}
  argument; this is an easy way to transfer e.g. data frames without having
  to manually do the JSON encoding.

  When the function is invoked, the \code{this} keyword will refer to the
  widget instance object.
}
\examples{
\dontrun{
library(leaflet)

# This example uses browser geolocation. RStudio users:
# this won't work in the Viewer pane; try popping it
# out into your system web browser.
leaflet() \%>\% addTiles() \%>\%
  onRender("
    function(el, x) {
      // Navigate the map to the user's location
      this.locate({setView: true});
    }
  ")


# This example shows how you can make an R data frame available
# to your JavaScript code.

meh <- "&#x1F610;";
yikes <- "&#x1F628;";

df <- data.frame(
  lng = quakes$long,
  lat = quakes$lat,
  html = ifelse(quakes$mag < 5.5, meh, yikes),
  stringsAsFactors = FALSE
)

leaflet() \%>\% addTiles() \%>\%
  fitBounds(min(df$lng), min(df$lat), max(df$lng), max(df$lat)) \%>\%
  onRender("
    function(el, x, data) {
      for (var i = 0; i < data.lng.length; i++) {
        var icon = L.divIcon({className: '', html: data.html[i]});
        L.marker([data.lat[i], data.lng[i]], {icon: icon}).addTo(this);
      }
    }
  ", data = df)
}

}
\seealso{
\code{\link{onStaticRenderComplete}}, for writing custom JavaScript
  that involves multiple widgets.
}
