% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proquint.R
\name{int_to_proquint}
\alias{int_to_proquint}
\alias{proquint_to_int}
\alias{proquint_word_to_int}
\alias{int_to_proquint_word}
\title{Convert to and from proquints}
\usage{
int_to_proquint(x, use_cache = TRUE)

proquint_to_int(p, as = "numeric", use_cache = TRUE)

proquint_word_to_int(w, use_cache = TRUE, validate = TRUE)

int_to_proquint_word(i, use_cache = TRUE, validate = TRUE)
}
\arguments{
\item{x}{An integer (or integer-like) value to convert to a
proquint}

\item{use_cache}{Because there are relatively few combinations per
word, and because constructing short strings is relatively
expensive in R, it may be useful to cache all 65536 possible
words.  If \code{TRUE} then the first time that this function is
used all words will be cached and the results used - the first
time may take up to ~1/4 of a second and subsequent calls will
be much faster.  The identifiers selected will not change with
this option (i.e., given a particular random seed, changing this
option will not affect the identifiers randomly selected).}

\item{p}{A character vector representing a proquint}

\item{as}{The target data type for conversion from proquint.  The
options are \code{integer}, \code{numeric} and \code{bignum}.
The first two will overflow given sufficiently large input -
this will throw an error (overflow is at
\code{.Machine$integer.max} and \code{2 / .Machine$double.eps - 1}
for \code{integer} and \code{numeric} respectively).  For
\code{bignum} this will return a \emph{list} of \code{bignum}
elements \emph{even if \code{p} is of length 1}.}

\item{w}{A proquint \emph{word} (five letter string)}

\item{validate}{Validate the range of inputs?  Because these
functions are used internally, they can skip input validation.
You can too if you promise to pass sanitised input in.  If
out-of-range values are passed in and validation is disabled the
behaviour is undefined and subject to change.}

\item{i}{An integer representing a single proquint word (in the
range 0:65535)}
}
\description{
Convert to and from proquints.
}
\details{
These functions try to be type safe and predictable about what
they will and will not return.

For \code{proquint_to_int}, because numeric overflow is a
possibility, it is important to consider whether a proquint can be
meaninfully translated into an integer or a numeric and the
functions will throw an error rather than failing in a more
insidious way (promoting the type or returning NA).

\code{proquint_word_to_int} always retuns an integer vector of the
same length as the input.

Missing values are allowed; a missing integer representation of a
proquint will translate as \code{NA_character_} and a missing
proquint will translate as \code{NA_integer_} (if \code{as =
"integer"}), \code{NA_real_}, if \code{as = "numeric"} or as
\code{NULL} (if \code{as = "bignum"}).

Names are always discarded.  Future versions may gain an argument
\code{named} with a default of \code{FALSE}, but that setting to
\code{TRUE} would preseve names.  Let me know if this would be
useful.
}
