% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ellipsis_info.R
\name{ellipsis_info}
\alias{ellipsis_info}
\alias{ellipsis_info.default}
\title{Gather information about objects in ellipsis (dot dot dot)}
\usage{
ellipsis_info(objects, ...)

\method{ellipsis_info}{default}(..., only_models = TRUE)
}
\arguments{
\item{objects, ...}{Arbitrary number of objects.}

\item{only_models}{Only keep supported models (default to \code{TRUE}).}
}
\value{
The list with objects that were passed to the function, including
additional information as attributes (e.g. if models have same response or
are nested).
}
\description{
Provides information regarding the models entered in an ellipsis.
It detects whether all are models, regressions, nested regressions etc.,
assigning different classes to the list of objects.
}
\examples{
m1 <- lm(Sepal.Length ~ Petal.Width + Species, data = iris)
m2 <- lm(Sepal.Length ~ Species, data = iris)
m3 <- lm(Sepal.Length ~ Petal.Width, data = iris)
m4 <- lm(Sepal.Length ~ 1, data = iris)
m5 <- lm(Petal.Width ~ 1, data = iris)

objects <- ellipsis_info(m1, m2, m3, m4)
class(objects)

objects <- ellipsis_info(m1, m2, m4)
attributes(objects)$is_nested

objects <- ellipsis_info(m1, m2, m5)
attributes(objects)$same_response
}
